# MODAVA Flutter MVP Screen Plan

This document outlines all the Flutter screens required for the MVP, including the exact API endpoints they will call and the minimal fields needed to render the UI.

## 1. Authentication & Onboarding Screens

### 1.1 LoginScreen
**Purpose:** User authentication and login
**API Endpoints:**
- `POST /api/auth/login`

**Required Fields to Render:**
- Email input field
- Password input field
- Login button
- "Forgot password" link (future)
- "Sign up" link

**Empty/Loading/Error States:**
- Loading: Show spinner on button during API call
- Error: Toast message for invalid credentials
- Success: Navigate to main app

**Navigation:**
- Success → MainApp (with bottom navigation)
- Error → Stay on screen with error message

### 1.2 SignupScreen
**Purpose:** New user registration
**API Endpoints:**
- `POST /api/auth/signup`

**Required Fields to Render:**
- Email input field
- Password input field
- Confirm password field
- Business name input field (optional)
- Sign up button
- "Already have account" link

**Empty/Loading/Error States:**
- Loading: Show spinner on button during API call
- Error: Toast message for validation errors
- Success: Navigate to onboarding

**Navigation:**
- Success → OnboardingScreen
- Error → Stay on screen with error message

### 1.3 OnboardingScreen
**Purpose:** Complete vendor profile setup
**API Endpoints:**
- `POST /api/vendors/onboarding`

**Required Fields to Render:**
- Business name input field
- Profile picture upload (optional)
- Phone number input field
- Complete profile button

**Empty/Loading/Error States:**
- Loading: Show spinner on button during API call
- Error: Toast message for validation errors
- Success: Navigate to main app

**Navigation:**
- Success → MainApp
- Error → Stay on screen with error message

## 2. Main App Screens

### 2.1 MainApp (Scaffold with Bottom Navigation)
**Purpose:** Main app container with navigation
**API Endpoints:**
- `GET /api/auth/profile` (on app start)

**Required Fields to Render:**
- Bottom navigation bar with tabs:
  - Dashboard
  - Customers
  - Invoices
  - Reminders
  - Profile
- App bar with user info and logout

**Empty/Loading/Error States:**
- Loading: Show splash screen while fetching profile
- Error: Show error dialog and retry option
- Success: Display main app with user data

### 2.2 DashboardScreen
**Purpose:** Overview of business metrics
**API Endpoints:**
- `GET /api/auth/profile`
- `GET /api/customers` (count only)
- `GET /api/invoices` (recent only)
- `GET /api/subscriptions/my-plan`

**Required Fields to Render:**
- Welcome message with business name
- Customer count card
- Recent invoices card (last 5)
- Current plan status
- Quick action buttons:
  - Add Customer
  - Create Invoice
  - Send Reminder

**Empty/Loading/Error States:**
- Empty: Show onboarding CTA if no customers
- Loading: Show skeleton cards
- Error: Show retry button with error message

## 3. Customer Management Screens

### 3.1 CustomersListScreen
**Purpose:** List and search customers
**API Endpoints:**
- `GET /api/customers?search={query}&tag={tag}`

**Required Fields to Render:**
- Search bar with text input
- Filter chips (All, Tagged, Flagged)
- Customer list with items:
  - Customer avatar/initial
  - Name
  - Phone number
  - Last order date
  - Measurements count
  - Flag status indicator
- Floating action button: Add Customer
- Pull-to-refresh

**Empty/Loading/Error States:**
- Empty: "No customers yet" with CTA to add first customer
- Loading: Show skeleton list items
- Error: Show retry button with error message

**Navigation:**
- Customer item tap → CustomerDetailScreen
- Add button → AddCustomerScreen

### 3.2 CustomerDetailScreen
**Purpose:** View customer details and measurements
**API Endpoints:**
- `GET /api/customers/:customerId`

**Required Fields to Render:**
- Customer header:
  - Name (large)
  - Phone number
  - Email
  - Notes
  - Flag status
- Measurements section:
  - List of measurement types and values
  - Add/edit measurement button
- Actions section:
  - Edit customer button
  - Create invoice button
  - Send reminder button
  - Delete customer button

**Empty/Loading/Error States:**
- Empty: Show "No measurements" message
- Loading: Show skeleton content
- Error: Show retry button with error message

**Navigation:**
- Edit button → EditCustomerScreen
- Add invoice → CreateInvoiceScreen
- Add reminder → CreateReminderScreen

### 3.3 AddCustomerScreen
**Purpose:** Create new customer profile
**API Endpoints:**
- `POST /api/customers`

**Required Fields to Render:**
- Customer name input field
- Phone number input field
- Email input field (optional)
- Notes text area (optional)
- Save button
- Cancel button

**Empty/Loading/Error States:**
- Loading: Show spinner on save button
- Error: Show validation errors below fields
- Success: Navigate back to customers list

**Navigation:**
- Success → CustomersListScreen
- Cancel → Pop back

### 3.4 EditCustomerScreen
**Purpose:** Update customer information
**API Endpoints:**
- `PUT /api/customers/:customerId`

**Required Fields to Render:**
- Pre-filled customer name input field
- Pre-filled phone number input field
- Pre-filled email input field
- Pre-filled notes text area
- Save button
- Cancel button

**Empty/Loading/Error States:**
- Loading: Show spinner on save button
- Error: Show validation errors below fields
- Success: Navigate back to customer detail

**Navigation:**
- Success → CustomerDetailScreen
- Cancel → Pop back

### 3.5 MeasurementsScreen
**Purpose:** Manage customer measurements
**API Endpoints:**
- `POST /api/customers/:customerId/measurements`

**Required Fields to Render:**
- Customer name header
- Measurements list:
  - Measurement type (e.g., "Chest", "Waist", "Hip")
  - Value input field
  - Unit dropdown (cm, inches, etc.)
- Add measurement button
- Save all button

**Empty/Loading/Error States:**
- Empty: Show "No measurements" message
- Loading: Show spinner on save button
- Error: Show validation errors below fields

**Navigation:**
- Success → Pop back to customer detail
- Cancel → Pop back

## 4. Invoice Management Screens

### 4.1 InvoicesListScreen
**Purpose:** List and manage invoices
**API Endpoints:**
- `GET /api/invoices`

**Required Fields to Render:**
- Invoice list with items:
  - Invoice number/ID
  - Customer name
  - Total amount
  - Status badge (draft, sent, paid, overdue)
  - Creation date
  - Payment status indicator
- Filter chips (All, Draft, Sent, Paid, Overdue)
- Floating action button: Create Invoice
- Pull-to-refresh

**Empty/Loading/Error States:**
- Empty: "No invoices yet" with CTA to create first invoice
- Loading: Show skeleton list items
- Error: Show retry button with error message

**Navigation:**
- Invoice item tap → InvoiceDetailScreen
- Create button → CreateInvoiceScreen

### 4.2 InvoiceDetailScreen
**Purpose:** View invoice details and manage status
**API Endpoints:**
- `GET /api/invoices/:id`

**Required Fields to Render:**
- Invoice header:
  - Invoice number
  - Customer name
  - Total amount
  - Status badge
  - Creation date
- Invoice items list:
  - Item name
  - Quantity
  - Unit price
  - Total price
- Actions section:
  - Download PDF button
  - Send invoice button
  - Mark as paid button
  - Edit invoice button
  - Delete invoice button

**Empty/Loading/Error States:**
- Empty: Show "No items" message
- Loading: Show skeleton content
- Error: Show retry button with error message

**Navigation:**
- Edit button → EditInvoiceScreen
- Download → Open PDF viewer
- Send → Show confirmation dialog

### 4.3 CreateInvoiceScreen
**Purpose:** Create new invoice
**API Endpoints:**
- `POST /api/invoices`

**Required Fields to Render:**
- Customer selection dropdown
- Invoice items section:
  - Item name input field
  - Quantity input field
  - Unit price input field
  - Add item button
- Invoice summary:
  - Subtotal
  - Tax (if applicable)
  - Total amount
- Save as draft button
- Send invoice button
- Cancel button

**Empty/Loading/Error States:**
- Loading: Show spinner on action buttons
- Error: Show validation errors below fields
- Success: Navigate to invoice detail

**Navigation:**
- Success → InvoiceDetailScreen
- Cancel → Pop back

### 4.4 EditInvoiceScreen
**Purpose:** Modify existing invoice
**API Endpoints:**
- `PUT /api/invoices/:id`

**Required Fields to Render:**
- Pre-filled customer selection
- Pre-filled invoice items with edit capability
- Invoice summary with real-time calculation
- Save changes button
- Cancel button

**Empty/Loading/Error States:**
- Loading: Show spinner on save button
- Error: Show validation errors below fields
- Success: Navigate back to invoice detail

**Navigation:**
- Success → InvoiceDetailScreen
- Cancel → Pop back

## 5. Reminder & CRM Screens

### 5.1 RemindersListScreen
**Purpose:** List and manage customer reminders
**API Endpoints:**
- `GET /api/reminders/list`

**Required Fields to Render:**
- Reminders list with items:
  - Customer name
  - Reminder message preview
  - Scheduled date/time
  - Status badge (draft, scheduled, sent)
  - Type indicator (follow-up, measurement, etc.)
- Filter chips (All, Draft, Scheduled, Sent)
- Floating action button: Create Reminder
- Pull-to-refresh

**Empty/Loading/Error States:**
- Empty: "No reminders yet" with CTA to create first reminder
- Loading: Show skeleton list items
- Error: Show retry button with error message

**Navigation:**
- Reminder item tap → ReminderDetailScreen
- Create button → CreateReminderScreen

### 5.2 CreateReminderScreen
**Purpose:** Create new customer reminder
**API Endpoints:**
- `POST /api/reminders/create`

**Required Fields to Render:**
- Customer selection dropdown
- Reminder message text area
- Reminder type dropdown (follow-up, measurement, payment)
- Schedule options:
  - Send now
  - Schedule for later (date picker)
- Send button
- Save as draft button
- Cancel button

**Empty/Loading/Error States:**
- Loading: Show spinner on action buttons
- Error: Show validation errors below fields
- Success: Navigate back to reminders list

**Navigation:**
- Success → RemindersListScreen
- Cancel → Pop back

### 5.3 ReminderDetailScreen
**Purpose:** View reminder details and manage
**API Endpoints:**
- `POST /api/reminders/send/:id`

**Required Fields to Render:**
- Reminder header:
  - Customer name
  - Message content
  - Type and status
  - Scheduled date/time
- Actions section:
  - Send now button
  - Edit reminder button
  - Delete reminder button

**Empty/Loading/Error States:**
- Loading: Show spinner on action buttons
- Error: Show error message
- Success: Show confirmation message

**Navigation:**
- Edit button → EditReminderScreen
- Send → Show confirmation dialog
- Delete → Show confirmation dialog

## 6. Subscription & Billing Screens

### 6.1 SubscriptionPlansScreen
**Purpose:** View and select subscription plans
**API Endpoints:**
- `GET /api/subscriptions/plans`

**Required Fields to Render:**
- Plans list with items:
  - Plan name
  - Price (monthly/yearly)
  - Feature list
  - Trial period (if applicable)
  - Select plan button
- Current plan indicator
- Trial offer banner (if eligible)

**Empty/Loading/Error States:**
- Empty: Show "No plans available" message
- Loading: Show skeleton plan cards
- Error: Show retry button with error message

**Navigation:**
- Select plan → PlanConfirmationScreen
- Current plan → SubscriptionDetailScreen

### 6.2 SubscriptionDetailScreen
**Purpose:** View current subscription and features
**API Endpoints:**
- `GET /api/subscriptions/my-plan`
- `GET /api/subscriptions/my-features`

**Required Fields to Render:**
- Current plan header:
  - Plan name
  - Current status
  - Billing period
  - Next billing date
- Features list with availability indicators
- Plan actions:
  - Upgrade plan button
  - Cancel subscription button
- Usage statistics (if applicable)

**Empty/Loading/Error States:**
- Loading: Show skeleton content
- Error: Show retry button with error message

**Navigation:**
- Upgrade → SubscriptionPlansScreen
- Cancel → Show confirmation dialog

### 6.3 TrialOfferScreen
**Purpose:** Accept trial offer
**API Endpoints:**
- `GET /api/subscriptions/trial-offer`
- `POST /api/subscriptions/accept-trial`

**Required Fields to Render:**
- Trial offer details:
  - Plan name
  - Trial duration
  - Features included
  - Terms and conditions
- Accept trial button
- Decline button

**Empty/Loading/Error States:**
- Loading: Show spinner on accept button
- Error: Show error message
- Success: Navigate to main app

**Navigation:**
- Accept → MainApp
- Decline → Pop back

## 7. Profile & Settings Screens

### 7.1 ProfileScreen
**Purpose:** View and edit user profile
**API Endpoints:**
- `GET /api/auth/profile`
- `PUT /api/vendors/profile`

**Required Fields to Render:**
- Profile header:
  - Profile picture (editable)
  - Business name
  - Email address
- Profile sections:
  - Business information (editable)
  - Account settings
  - Subscription details
  - KYC status
- Actions:
  - Edit profile button
  - Change password button
  - Logout button

**Empty/Loading/Error States:**
- Loading: Show skeleton content
- Error: Show retry button with error message

**Navigation:**
- Edit profile → EditProfileScreen
- Change password → ChangePasswordScreen
- Logout → LoginScreen

### 7.2 EditProfileScreen
**Purpose:** Modify profile information
**API Endpoints:**
- `PUT /api/vendors/profile`

**Required Fields to Render:**
- Pre-filled business name input field
- Profile picture upload/change
- Phone number input field
- Save button
- Cancel button

**Empty/Loading/Error States:**
- Loading: Show spinner on save button
- Error: Show validation errors below fields
- Success: Navigate back to profile

**Navigation:**
- Success → ProfileScreen
- Cancel → Pop back

### 7.3 KYCStatusScreen
**Purpose:** View KYC submission status
**API Endpoints:**
- `GET /api/kyc/status`

**Required Fields to Render:**
- KYC status header:
  - Current status badge
  - Submission date
  - Review date (if reviewed)
- Document upload section (if not submitted)
- Status explanation and next steps
- Contact support button (if needed)

**Empty/Loading/Error States:**
- Loading: Show skeleton content
- Error: Show retry button with error message

**Navigation:**
- Submit KYC → KYCSubmissionScreen
- Contact support → SupportScreen

## 8. Admin Screens (Admin Users Only)

### 8.1 AdminDashboardScreen
**Purpose:** Admin overview and system management
**API Endpoints:**
- `GET /api/admin/settings`
- `GET /api/admin/logs` (summary)

**Required Fields to Render:**
- System overview:
  - Total users count
  - Active subscriptions
  - System health status
- Quick actions:
  - Manage users button
  - System settings button
  - View logs button
- Recent activity feed

**Empty/Loading/Error States:**
- Loading: Show skeleton content
- Error: Show retry button with error message

**Navigation:**
- Manage users → AdminUsersScreen
- System settings → AdminSettingsScreen
- View logs → AdminLogsScreen

### 8.2 AdminUsersScreen
**Purpose:** Manage system users
**API Endpoints:**
- `GET /api/admin/users`
- `POST /api/admin/users`
- `PATCH /api/admin/users/:id/permissions`

**Required Fields to Render:**
- Users list with items:
  - User email
  - Role badge
  - Status indicator
  - Last login date
- Actions per user:
  - Edit permissions button
  - Impersonate button
  - Suspend/activate button
- Add user button

**Empty/Loading/Error States:**
- Loading: Show skeleton list items
- Error: Show retry button with error message

**Navigation:**
- Edit permissions → EditUserPermissionsScreen
- Impersonate → MainApp (as that user)
- Add user → AddUserScreen

## 9. Error & Loading Screens

### 9.1 ErrorScreen
**Purpose:** Display error messages with retry options
**Required Fields to Render:**
- Error icon
- Error message
- Error details (optional)
- Retry button
- Go back button
- Contact support button

**Navigation:**
- Retry → Retry previous action
- Go back → Pop back
- Contact support → SupportScreen

### 9.2 LoadingScreen
**Purpose:** Show loading states during API calls
**Required Fields to Render:**
- Loading spinner
- Loading message
- Progress indicator (if applicable)
- Cancel button (if applicable)

**Navigation:**
- Auto-navigate when loading completes
- Cancel → Pop back or show error

## 10. Toast & Notification Patterns

### 10.1 Success Toast
**Pattern:** Green background, checkmark icon, brief message
**Examples:**
- "Customer saved successfully"
- "Invoice created"
- "Reminder sent"

### 10.2 Error Toast
**Pattern:** Red background, X icon, error message
**Examples:**
- "Failed to save customer"
- "Network error"
- "Invalid email format"

### 10.3 Info Toast
**Pattern:** Blue background, info icon, informational message
**Examples:**
- "Syncing data..."
- "Feature available on Premium plan"
- "KYC review in progress"

## UNKNOWN Areas

The following screens are referenced in the code but not fully documented:

- **Shopping List Screens**: Module exists but endpoints unclear
- **Inventory Management Screens**: Schema exists but API unclear
- **Order Management Screens**: E-commerce flow not implemented
- **AI Assistant Screens**: Module exists but functionality unclear
- **Greetings Screens**: Module exists but purpose unclear

**File paths to investigate:**
- `src/modules/shoppinglists/`
- `src/modules/ai/`
- `src/modules/greetings/`
- `src/modules/notifications/`

## Screen Count Summary

**Total Screens Required for MVP: 25**

**By Category:**
- Authentication & Onboarding: 3 screens
- Main App & Dashboard: 2 screens
- Customer Management: 5 screens
- Invoice Management: 4 screens
- Reminder & CRM: 3 screens
- Subscription & Billing: 3 screens
- Profile & Settings: 3 screens
- Admin (Optional): 2 screens
- Error & Loading: 2 screens

**Priority Levels:**
- **High Priority (Core MVP):** 18 screens
- **Medium Priority (Enhanced Features):** 5 screens
- **Low Priority (Admin Features):** 2 screens
